using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using gov.va.med.vbecs.Common;
using gov.va.med.vbecs.BOL;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgDivisionLogonPopup
	/// </summary>
	public class DlgDivisionLogonPopup : VbecsBaseForm
	{
		private Button btnOK;
		private System.Windows.Forms.RichTextBox txtIntroText;
		private IContainer components = null;

		/// <summary>
		/// Primary constructor
		/// </summary>
		/// <param name="division">Division to display logon text for.</param>
		public DlgDivisionLogonPopup( Division division ) :
			this()
		{
			if( division == null )
				throw( new ArgumentNullException( "division" ) );

			this.txtIntroText.Text = division.DivisionAlerts.LoginMessage;
		}

		/// <summary>
		/// DisplayLogonMessagePopup
		/// </summary>
		/// <param name="division"></param>
		/// <param name="owner"></param>
		public static void DisplayLogonMessagePopup( Division division, IWin32Window owner )
		{
#if !DEBUG
			if( division == null )
				throw( new ArgumentNullException( "division" ) );

			if( owner == null )
				throw( new ArgumentNullException( "owner" ) );

			if( division.DivisionAlerts == null || 
				division.DivisionAlerts.LoginMessage == null ||
				division.DivisionAlerts.LoginMessage.Trim() == String.Empty )
				return;

			new DlgDivisionLogonPopup( division ).ShowDialog( owner );
#endif
		}

		/// <summary>
		/// This constructor is used to give WinForms designer an ability to 
		/// create and display the form.
		/// </summary>
		internal DlgDivisionLogonPopup() : base( false )
		{			
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this.vbecsLogo1.Title = "Login Message";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC018.DlgDivisionLogonPopup());
			//
			RequiredFieldsLabel = false;

			SetThisToolTip( btnOK, StrRes.OtherMsg.UC018.DivisionLoginMessagebtnOK() );
			SetThisToolTip( txtIntroText, StrRes.OtherMsg.UC018.DivisionLoginMessagetxtIntroText() );
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.btnOK = new System.Windows.Forms.Button();
			this.txtIntroText = new System.Windows.Forms.RichTextBox();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(354, 30);
			this.vbecsLogo1.Title = "Login Message";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 320);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.Visible = false;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.DialogResult = System.Windows.Forms.DialogResult.OK;
			this.btnOK.Location = new System.Drawing.Point(276, 309);
			this.btnOK.Name = "btnOK";
			this.btnOK.TabIndex = 0;
			this.btnOK.Text = "&OK";
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			// 
			// txtIntroText
			// 
			this.txtIntroText.AccessibleDescription = "Login Message";
			this.txtIntroText.AccessibleName = "Login Message";
			this.txtIntroText.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtIntroText.BackColor = System.Drawing.SystemColors.Info;
			this.txtIntroText.BorderStyle = System.Windows.Forms.BorderStyle.FixedSingle;
			this.txtIntroText.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtIntroText.ForeColor = System.Drawing.SystemColors.InfoText;
			this.txtIntroText.Location = new System.Drawing.Point(8, 36);
			this.txtIntroText.Name = "txtIntroText";
			this.txtIntroText.ReadOnly = true;
			this.txtIntroText.Size = new System.Drawing.Size(340, 269);
			this.txtIntroText.TabIndex = 3;
			this.txtIntroText.Text = "";
			// 
			// DlgDivisionLogonPopup
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnOK;
			this.ClientSize = new System.Drawing.Size(354, 336);
			this.Controls.Add(this.txtIntroText);
			this.Controls.Add(this.btnOK);
			this.FormBorderStyle = System.Windows.Forms.FormBorderStyle.SizableToolWindow;
			this.hlphelpChm.SetHelpKeyword(this, "Log_onto_VBECS_and_VistA.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(360, 360);
			this.Name = "DlgDivisionLogonPopup";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Login Message";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.txtIntroText, 0);
			this.ResumeLayout(false);

		}
		#endregion

		private void btnOK_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}
	}
}
